import { ItemStack, Player, world } from '@minecraft/server';

world.events.entityHit.subscribe((data) => {
  if (
    data.entity instanceof Player &&
    data.hitEntity?.typeId === 'minecraft:husk'
  ) {
    let husk = data.hitEntity;
    let huskInv = husk.getComponent('equipment_inventory');
    huskInv.setEquipment('head', new ItemStack('diamond_helmet'));
    world.sendMessage('Diamond Helmet equipped! Now get away until the Husk is no longer being rendered, then return! Only then the Diamond Helmet should render.');
  }
});